define(['app', 'page_service'], function (app) {
	"use strict";
	app.controller('FooterController', function ($scope, mhpuser, authenticationService, config, pageService) {
		$scope.VsID        ull;
		$scope.advocateForName = null;
		$scope.facilityName = null;
		$scope.appVersion = config.app.title + ' - v' + pageService.getVersionNumber();

		if (authenticationService.isAuthenticated()) {
			mhpuser.fetch().then(function (user) {
				loadUserDetails(user);
			});
		}

		function loadUserDetails(user) {
			if (user) {
				$scope.VsID        ser.displayName;

				if (isAdvocate(user)) {
					$scope.advocateForName = user.patient.displayName;
				} else if (user.facilityName) {
					$scope.facilityName = user.facilityName;
				}
			}
		}

		function isAdvocate(user) {
			return user.patient.patientIdentifier !== null
				&& user.patient.patientIdentifier.uniqueId !== null
				&& user.id !== user.patient.patientIdentifier.uniqueId;
		};
	});
});